import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.OverviewDoc;
import org.uddi4j.datatype.OverviewURL;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import java.security.Security;
import java.util.Vector;

public class UDDISaveTModel1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		AuthToken at = proxy.get_authToken("user", "password");

		TModel tm = new TModel("uuid:1ec88662-04b6-4231-a47f-39529db6f22c", "servicesweb-compagnie-com:inquiry");
//		TModel tm = new TModel("uuid:8bab3c52-3056-42a0-8247-69df3ba5fcea", "servicesweb-compagnie-com:inquiry");

		Vector tmdsv = new Vector();
		Description tmd = new Description("API de recherche UDDI 2.0 - Duplication de la version officielle");
		tmdsv.addElement(tmd);
		tm.setDescriptionVector(tmdsv);

		OverviewURL oURL = new OverviewURL("http://www.uddi.org/wsdl/inquire_v2.wsdl"); 
		OverviewDoc oDoc = new OverviewDoc();
		oDoc.setOverviewURL(oURL);

		Vector oddsv = new Vector();
		Description odd = new Description("Fonctions de l'API de recherche pour interroger un annuaire UDDI.");
		oddsv.addElement(odd);
		oDoc.setDescriptionVector(oddsv);

		tm.setOverviewDoc(oDoc);

		Vector cbv = new Vector();

		KeyedReference naics = new KeyedReference("Information", "51");
		naics.setTModelKey(TModel.NAICS_TMODEL_KEY);
		cbv.addElement(naics);
		naics = new KeyedReference("Information Services and Data Processing Services", "514");
		naics.setTModelKey(TModel.NAICS_TMODEL_KEY);
		cbv.addElement(naics);
		naics = new KeyedReference("Data Processing Services", "5142");
		naics.setTModelKey(TModel.NAICS_TMODEL_KEY);
		cbv.addElement(naics);

		KeyedReference unspsc = new KeyedReference("Communications and Computer Equipment and Peripherals and Components and Supplies", "43.00.00.00.00");
		unspsc.setTModelKey(TModel.UNSPSC_73_TMODEL_KEY);
		cbv.addElement(unspsc);
		unspsc = new KeyedReference("Internet and intranet software", "43.16.28.00.00");
		unspsc.setTModelKey(TModel.UNSPSC_73_TMODEL_KEY);
		cbv.addElement(unspsc);

		KeyedReference geo = new KeyedReference("France", "FR");
		geo.setTModelKey(TModel.ISO_CH_TMODEL_KEY);
		cbv.addElement(geo);
		geo = new KeyedReference("Ile-De-France", "FR-J");
		geo.setTModelKey(TModel.ISO_CH_TMODEL_KEY);
		cbv.addElement(geo);
		geo = new KeyedReference("Hauts-De-Seine", "FR-92");
		geo.setTModelKey(TModel.ISO_CH_TMODEL_KEY);
		cbv.addElement(geo);

		CategoryBag cb = new CategoryBag();
		cb.setKeyedReferenceVector(cbv);
		tm.setCategoryBag(cb);

		Vector tModels = new Vector();
		tModels.add(tm);
		TModelDetail tmld = proxy.save_tModel(at.getAuthInfoString(), tModels);
		System.out.println( "new tmodel saved\n" );

		TModelList tl = proxy.find_tModel("servicesweb-compagnie-com:inquiry", null, null, null, 0);

		TModelInfos tis = tl.getTModelInfos();
		if (tis.size() == 0) {
			System.out.println("no tmodel(s) found");
		}
		else {
			System.out.println(tis.size()+" tmodel(s) found\n");
			Vector tiv = tis.getTModelInfoVector();
			for (int i = 0; i < tiv.size(); i++) {
				TModelInfo ti = (TModelInfo)tiv.elementAt(i);
				System.out.println(ti.getNameString());
				System.out.println(ti.getTModelKey());
				System.out.println("\n");
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}